<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Singleton pattern for an imap connection.
* Instantiates a new imap connection when necessary, or returns a reference to the existing one.
*/
function imap_connection(){
	//do we already have an imap connection established?  if so, let's just return a reference to that.
	$CI = get_instance();
	if(isset($CI->imap_connection) && is_resource($CI->imap_connection)) 
		return $CI->imap_connection;
	
#	get_instance()->error->notice('Establishing imap_connection()');
#	log_message('error', 'Establishing imap_connection()');
	
	// Set IMAP server params
	$hostname = IMAP_HOSTNAME;
	$port = IMAP_PORT;
	$flags = IMAP_SERVICEFLAGS;
	$mailbox = element('mailbox', $_SESSION, 'INBOX');
	$username = $CI->session->userdata('username');
	$password = $CI->encrypt->decode($CI->session->userdata('ep'));
	$imap_connection = imap_open('{'.$hostname.':'.$port. $flags .'}' . $mailbox, $username, $password, NULL, 1);
	log_imap_errors();
	
	//log some useful errors if we can't connect to IMAP
	if(!is_resource($imap_connection)){
		
		$error_description = '';
		foreach(array('hostname', 'port', 'flags', 'mailbox', 'username') as $var){
			$error_description .= strtoupper(humanize($var)).': '.$CI->error->describe($$var)."\n\t";
		}
		$success = false; //PHP only lets variables be returned by reference, so we're going to need one to return
		$CI->error->warning('I could not connect to IMAP with the following settings: '."\n\t".$error_description);
		return $success;
	}
	$CI->imap_connection = &$imap_connection;
	return $imap_connection;
}


function log_imap_errors($errors = null){
	if(is_null($errors)) $errors = imap_errors();
	if(empty($errors)) return;
	foreach($errors as $error){
		get_instance()->error->warning($error, $offset = 1);
	}
}


function get_mime_type(&$structure) { 
    $primary_mime_type = array("TEXT", "MULTIPART", "MESSAGE", "APPLICATION", "AUDIO", "IMAGE", "VIDEO", "OTHER"); 
    if($structure->subtype) { 
         return $primary_mime_type[(int) $structure->type] . '/' . $structure->subtype; 
     } 
     return "TEXT/PLAIN"; 
}

function get_part($stream, $msg_number, $mime_type, $structure = false, $part_number = false) { 

	$prefix = "";

    if (!$structure) { 
         $structure = imap_fetchstructure($stream, $msg_number); 
     } 
    if($structure) { 
         if($mime_type == get_mime_type($structure)) { 
              if(!$part_number) { 
                   $part_number = "1"; 
               } 
              $text = imap_fetchbody($stream, $msg_number, $part_number); 
              if($structure->encoding == 3) { 
                   return imap_base64($text); 
               } else if ($structure->encoding == 4) { 
                   return imap_qprint($text); 
               } else { 
                   return $text; 
            } 
        } 
         if ($structure->type == 1) { /* multipart */ 
              while (list($index, $sub_structure) = each($structure->parts)) { 
                if ($part_number) { 
                    $prefix = $part_number . '.'; 
                } 
                $data = get_part($stream, $msg_number, $mime_type, $sub_structure, $prefix . ($index + 1)); 
                if ($data) { 
                    return $data; 
                } 
            } 
        } 
    } 
    return false; 
}

function get_decode_value($message,$coding) 
        { 
        if ($coding == 0)  
        {  
           $message = imap_8bit($message);  
        }  
        elseif ($coding == 1)  
        {  
          $message = imap_8bit($message);  
        }  
        elseif ($coding == 2)  
        {  
           $message = imap_binary($message);  
        }  
        elseif ($coding == 3)  
        {  
       $message=imap_base64($message);  
       }  
        elseif ($coding == 4)  
        {  
           $message = imap_qprint($message);  
        }  
        elseif ($coding == 5)  
        {  
         $message = imap_base64($message);  
        }  
        return $message; 
        } 